// VMF settings class
local CLimits	= OOP_Derive( CDatabase );

// constructor.
function CLimits:__ctor( )
	// setup the vmf info table.
	if( !self:TableExists( "vmfsuite_vmfinfo" ) ) then
		self:Query(
			"CREATE TABLE IF NOT EXISTS vmfsuite_vmfinfo ( filename VARCHAR(255), flag VARCHAR(32), spawnlimit INTEGER );"
		);
	
	end
	
end


// vmf limits
function CLimits:SetLimit( filename, limit )
	// already eists?
	if( self:Query( "SELECT filename FROM vmfsuite_vmfinfo WHERE filename = '" .. filename .. "' LIMIT 1" ) ) then
		// update
		self:Query(
			"UPDATE vmfsuite_vmfinfo SET spawnlimit = " .. limit .. " WHERE filename = '" .. filename .. "' LIMIT 1"
		);
		
	else
		// add
		self:Query(
			"INSERT INTO vmfsuite_vmfinfo ( filename, state, spawnlimit ) VALUES ( '" .. filename .. "', " .. VMF_FLAG_NONE .. ", " .. limit .. " )"
		);
		
	end

end

function CLimits:GetLimit( filename )
	// fetch flag if it exists.
	local res = self:Query( "SELECT state FROM vmfsuite_vmfinfo WHERE filename = '" .. filename .. "' LIMIT 1" );
	if( !res ) then return -1; end
	
	// flag exists return flag.
	return res[1][ 'spawnlimit' ];

end


// create
VMFSuite.LimitsSystem = CLimits:create();
